# 시간복잡도와 공간복잡도

CS에서는 하나의 문제에 대하여 여러 알고리즘을 사용하여, 다양한 방식으로 문제를 해결할 수 있다. 이 때 어떠한 솔루션이 최적인지 판단하기 위한 기준이 필요하다.

이 때 기준은 알고리즘을 수행하는 **시스템 및 구성과는 독립적** 이어야하고, **입력된 수와 상관관계** 를 나타낼 수 있어야한다.

이를 만족하는 기준이 **시간복잡도** 와 **공간복잡도** 이다.

`시간복잡도`: 특정한 크기의 입력에 대하여 알고리즘의 **수행 시간** 분석

`공간복잡도`: 특정한 크기의 입력에 대하여 알고리즘의 **메모리 사용량** 분석

<br/>

## 점근적 표기법 Big-Ω, Big-θ, Big-O

알고리즘의 성능은 입력의 크기가 충분히 클 때의 성능이 중요하다. 그래서 알고리즘의 수행 시간은 항상 입력의 크기가 충분히 클 때를 분석한다. 즉, 입력 `n -> ∞` 일 때를 분석하기 위해 점근적 분석을 해야한다.

**O (빅오,Big-O)**  
최악의 경우(Worst Case)를 나타냅니다. 즉, 최대로 걸릴 수 있는 시간(상한 시간)을 의미한다.

**Ω (빅오메가,Big-Omega)**  
최선의 경우(Best Case)를 나타냅니다. 즉, 최소로 걸릴 수 있는 시간(하한 시간)을 의미한다.

**θ (빅세타,Big-Theta)**  
최선과 최악의 중간(Average Case)을 나타냅니다. 즉 평균적인 복잡도를 의미한다.

3가지의 표기법을 제시하지만 알고리즘의 성능 측정 지표로 주로 사용되는 것은 빅오 표기법이다다. 그 이유인 즉슨 '아무리 최악의 상황이라도 보장할 수 있는 상한시간의 성능'표기 필요성과, 알고리즘이 복잡해질수록 평균적인 경우를 구하는 것의 어려움 때문이다.

<br/>

## 시간복잡도(Time Complexity)

시간복잡도는 알고리즘의 수행시간에 관한 분석 기준이다. 알고리즘의 절대적인 실행 시간을 나타내는 것이 아닌, 알고리즘을 수행하는 데 기본 연산들이 몇 번 이루어지는 지를 입력된 데이터 N에 관한 함수 형태로 표현한다.

_(여기서 기본 연산은 데이터 입출력, 산술 연산, 제어 연산 등을 이야기한다.)_

시간 복잡도는 일반적으로 빅오 표기법으로 나타낸다. 점근적 표기법이므로 연산 횟수가 다항식으로 표현될 경우, 최고차항을 제외한 모든 항과 최고차항의 계수를 제외시킨다.

$T(n)=2n^2+3n+1=O(n^2)$

<br/>

#### O(1) 상수 시간(Constant time)

입력 크기(n)에 상관없이 일정한 연산을 수행하면 시간복잡도는 O(1)이다.

```ts
function printNumber(n: number) {
  console.log(n);
}
```

#### O(log n) 로그 시간(Logarithmic time)

아래 예시는 반복할 때 마다 i값이 2배로 증가한다. $2^k = n$ (k는 반복 횟수) 일 경우 종료되며, 양쪽에 로그를 씌우면 $k=logn$이 된다. 따라서 $O(logn)$ 의 시간복잡도를 갖는다. 예를 들어 데이터가 10배가 되면, 처리 시간은 2배가 된다.
대표적으로 이진 탐색이 있다.

```js
for (i = 1; i <= n; i * 2) {
  console.log(i);
}
```

#### O(n) 선형 시간(Linear time)

입력 크기 `n`에 비례하여 연산 횟수가 선형적으로 증가하는 경우 시간 복잡도는 $O(n)$ 이다. 예를 들어 데이터가 10배면 처리 시간도 10배가 된다. 대표적으로 1차원 for문이 있다.

```js
for (i = 0; i < n; i++) {
  console.log(i);
}
```

#### O(n log₂ n) (Linear-Logarithmic)
데이터가 많아질수록 처리 시간이 로그(log)배 만큼 늘어난다. 예를들어 데이터가 10배가 되면 처리 시간은 약 30배가 된다. 대표적으로 병합 정렬, 퀵 정렬이 있다.

#### O(n^2) 2차 시간 (Quadratic time)

입력 크기가 `n`일때 연산 횟수가 $n^2$의 형태로 증가하면 시간복잡도는 $O(n^2)$ 이다. 예를 들어 데이터가 10배가 되면, 처리 시간은 약 100배가 된다. 이중 루프가 대표적이다.

```js
for(i=0; i < n; i++) {
  for(j=0, j < n; j++) {
    console.log(i, j);
  }
}
```

#### O(2^n) 지수 시간 (Exponential time)

입력 크기가 `n`일때 연산 횟수가 $2^n$의 형태로 증가하면 시간복잡도는 $O(2^n)$ 이다. 예를 들어 데이터가 10배가 되면 처리 시간은 약 1,024배가 된다. 대표적으로 피보나치 수열이 있다.

```ts
function recursive(n: number) {
  if (n <= 1) return n;
  return recursive(n - 1) + recursive(n - 2);
}
```

<img src="https://user-images.githubusercontent.com/66757141/209467139-8303a91e-2d0b-41bd-8f79-6ba8daf8d355.png" alt="big o complexity chart" width="700px" />

[https://www.bigocheatsheet.com/](https://www.bigocheatsheet.com/)

$O(1) \lt O(log n) \lt O(n) \lt O(n log n) \lt O(n^2) \lt O(2^n) \lt O(n!)$

#### 빅오 표기법 예제
O(1) : 스택의 Push, Pop<br/>
O(log n) : 이진트리<br/>
O(n) : for 문<br/>
O(n log n) : 퀵 정렬(quick sort), 병합정렬(merge sort), 힙 정렬(heap Sort)<br/>
O(n²): 이중 for 문, 삽입정렬(insertion sort), 거품정렬(bubble sort), 선택정렬(selection sort)<br/>
O(2ⁿ) : 피보나치 수열


<br/>

## 공간복잡도(Space Complexity)

공간복잡도는 알고리즘의 메모리 사용량에 관한 분석 기준이다. 최근에는 컴퓨터 성능의 발달로 메모리 공간이 여유로워져 제약이 많이 사라졌고, 이에 따라 공간복잡도의 중요성이 비교적 적어져 최근 시간복잡도를 우선시 하는 경향이 있다.

일반적이다 공간복잡도 역시 시간복잡도 처럼 최악의 경우(worst case)를 빅오 노테이션으로 표기한다.

일반적으로 공간이 하나 생성되는 것을 1이라고 표현한다. 아래의 공간복잡도는 $O(1)$ 이다.

```js
const a = 1;
```

아래의 경우 역시 $O(1)$ 의 공간복잡도를 갖는다. 아래 예시에서 `n`회 반복되는 것은 공간복잡도에 영향을 끼치지 않으며 지역변수 i와 res만을 사용하기 때문에 상수 공간복잡도를 갖는다.

```ts
function factorial(n:number){
    int i = 0;
    int res = 1;
    for(i = 1; i <= n; i++){
        res = res * i;
    }
    return res;
}
```

아래의 예시는 $O(n)$ 의 공간복잡도를 갖는다. n의 값에 따라 재귀적으로 함수를 호출하며, `stack`에는 n부터 1까지 모든 값이 쌓이게 된다.

```ts
function factorial(n: number) {
  if (n > 1){
    return n * factorial(n - 1)
  };
  else return 1;
}
```

공간복잡도만을 고려할 경우 고정공간보다는 가변공간의 자료구조들을 사용하는것이 효율적이다.

함수 호출시 할당되는 지역변수들이나 동적 할당되는 객체들도 모두 공간이 필요하다. 재귀함수를 사용할 경우 매 호출마다 `매개변수`, `지역변수`, `함수의 복귀 주소` 를 저장할 공간이 필요하게 된다. 따라서 재귀적(Recursive)으로도, 반복문으로도 구현할 수 있다면 **반복문**으로 구현하는 것이 공간복잡도 측면에서 좋다고 볼 수 있다.

<br/>

---

## Reference

📄https://yoongrammer.tistory.com/79  
📄https://www.geeksforgeeks.org/time-complexity-and-space-complexity/  
📄https://lgphone.tistory.com/46  
📄https://yhmane.tistory.com/195  
📄https://detail-from-a-to-z.tistory.com/7  
📄https://coding-factory.tistory.com/609
